#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200000;
const int MXLOG = 18;

vector <int> tgraf[2][MAXN+5];
vector <int> graf[2][MAXN+5];
int sz[2][MAXN+5];
int in[2][MAXN+5];
int out[2][MAXN+5];
int tjm[2];
int par[2][MAXN+5][MXLOG];

bool is_parent(int idx, int a, int b){
    return (a == 0) || (in[idx][a] <= in[idx][b] && out[idx][b] <= out[idx][a]);
}
void dfs_size(int idx, int v, int p){
    par[idx][v][0] = p;
    for(int j=1; j<MXLOG; j++){
        par[idx][v][j] = par[idx][par[idx][v][j-1]][j-1];
    }
    sz[idx][v] = 1;
    for(auto c : tgraf[idx][v]){
        if(c == p) continue;
        graf[idx][v].push_back(c);
        dfs_size(idx, c, v);
        sz[idx][v] += sz[idx][c];
    }
}
int chroot[2][MAXN+5];
void dfs(int idx, int v){
    int mx = 0;
    in[idx][v] = ++tjm[idx];
    for(auto c : graf[idx][v]){
        if(sz[idx][c] > sz[idx][mx]) mx = c;
    }
    if(mx == 0){
        out[idx][v] = tjm[idx];
        return;
    }
    chroot[idx][mx] = chroot[idx][v];
    dfs(idx, mx);
    for(auto c : graf[idx][v]){
        if(c == mx) continue;
        chroot[idx][c] = c;
        dfs(idx, c);
    }
    out[idx][v] = tjm[idx];
}

int lca(int idx, int a, int b){
    if(is_parent(idx, a, b)) return a;
    for(int j=MXLOG-1; j>=0; j--) if(!is_parent(idx, par[idx][a][j], b)) a = par[idx][a][j];
    return par[idx][a][0];
}

int bit[MAXN+5];
void addbit(int x){
    while(x <= MAXN){
        bit[x]++;
        x += x & -x;
    }
}

int getbit(int x){
    int res = 0;
    while(x){
        res += bit[x];
        x -= x & -x;
    }
    return res;
}

bool ime[MAXN+5];

int pres[MAXN+5];
int vall[MAXN+5];

struct qvr{
    int sgn, val, koji;
};

vector <qvr> queries[MAXN+5];

int dokle(int idx, int v, int p){
    for(int j=MXLOG-1; j>=0; j--) if(!is_parent(idx, par[idx][v][j], p)) v = par[idx][v][j];
    return v;
}

void Resi(int N, int Q, int P, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R){
    for(int i=1; i<=N; i++) R[i] = 0;
    for(int i=1; i<N; i++){
        tgraf[0][U1[i]].push_back(V1[i]);
        tgraf[0][V1[i]].push_back(U1[i]);
    }
    dfs_size(0, 1, 0);
    chroot[0][1] = 1;
    dfs(0, 1);
    for(int i=1; i<=N; i++) pres[in[0][i]] = i;

    for(int i=1; i<N; i++){
        tgraf[1][in[0][U2[i]]].push_back(in[0][V2[i]]);
        tgraf[1][in[0][V2[i]]].push_back(in[0][U2[i]]);
    }
    dfs_size(1, 1, 0);
    chroot[1][1] = 1;
    dfs(1, 1);
    for(int i=1; i<=N; i++){
        vall[in[1][i]] = i;
    }
    for(int qr=1; qr<=Q; qr++){
        vector <pair <int, int>> ch1;
        vector <pair <int, int>> ch2;
        int a = A1[qr];
        int b = B1[qr];
        int g = lca(0, a, b);
        int lca1 = g;
        if(b == lca1){
            swap(a, b);
        }
        while(a){
            if(is_parent(0, chroot[0][a], g)){
                ch1.push_back({in[0][g], in[0][a]});
                break;
            }
            ch1.push_back({in[0][chroot[0][a]], in[0][a]});
            a = par[0][chroot[0][a]][0];
        }
        if(b != lca1){
            while(b){
                if(is_parent(0, chroot[0][b], g)){
                    ch1.push_back({in[0][dokle(0, b, g)], in[0][b]});
                    break;
                }
                ch1.push_back({in[0][chroot[0][b]], in[0][b]});
                b = par[0][chroot[0][b]][0];
                if(b == g) break;
            }
        }
        a = in[0][C1[qr]];
        b = in[0][D1[qr]];
        g = lca(1, a, b);
        int lca2 = g;
        if(lca2 == b){
            swap(a, b);
        }
        while(a){
            if(is_parent(1, chroot[1][a], g)){
                ch2.push_back({g, a});
                break;
            }
            ch2.push_back({chroot[1][a], a});
            a = par[1][chroot[1][a]][0];
        }
        if(b != g){
            while(b){
                if(is_parent(1, chroot[1][b], g)){
                    ch2.push_back({dokle(1, b, g), b});
                    break;
                }
                ch2.push_back({chroot[1][b], b});
                b = par[1][chroot[1][b]][0];
                if(b == g) break;
            }
        }
        for(auto c1 : ch1){
            for(auto c2 : ch2){
                int l1 = c1.first, r1 = c1.second;
                int l2 = in[1][c2.first], r2 = in[1][c2.second];
                queries[r2].push_back({1, r1, qr});
                queries[r2].push_back({-1, l1-1, qr});
                queries[l2-1].push_back({-1, r1, qr});
                queries[l2-1].push_back({1, l1-1, qr});
            }
        }
    }
    for(int i=1; i<=N; i++){
        addbit(vall[i]);
        for(auto kveri : queries[i]){
            R[kveri.koji] += kveri.sgn * getbit(kveri.val);
        }
    }
}

/*
10 1 0
1 2
1 4
2 5
2 3
3 10
4 6
6 9
4 8
8 7
1 3
3 8
3 5
3 4
5 9
1 6
6 2
2 7
2 10
10 7 9 7
*/

/*
8 8 0
1 2
1 3
2 4
1 5
3 6
5 7
6 8
1 2
2 3
3 4
4 5
5 6
6 7
5 8
8 4 6 7
2 6 6 7
4 7 2 7
7 7 1 4
2 6 8 3
7 1 7 6
6 6 7 4
2 8 8 2
*/